//cargo build --release pour compiler et faire un .exe

use reqwest;

use serde::Deserialize;

use std::error::Error;

use chrono::Local;

use chrono::Timelike; // Pour accéder aux heures et minutes

use colored::*;

use std::io::{self, Write};

use rand::seq::SliceRandom; // Importer le trait pour utiliser `choose`

use webbrowser;

use tokio::time; 

use std::process::{Command, Stdio};

use std::path::{Path, PathBuf};

use std::fs;

use std::os::windows::process::CommandExt;

use std::thread;

use std::env;

use std::fs::File;

use std::{time::Duration};

use rand::Rng; // Pour générer des couleurs aléatoires

use tts::Tts;

use std::{collections::HashMap, io::BufRead, io::BufReader};

use std::collections::HashSet;

use regex::Regex;

use unicode_normalization::UnicodeNormalization;

use unicode_normalization::char::is_combining_mark;

use textwrap::fill;

use directories::UserDirs;

use tokio::io::AsyncWriteExt;

use reqwest::Client;

 use reqwest::StatusCode;


#[derive(Deserialize, Debug)]
	
struct WeatherResponse 
{
	main: Main,
    	weather: Vec<Weather>,  //Nouveau champ pour les informations de base sur la météo
   	name: String,
    	wind: Wind,   // Nouveau champ pour les informations sur le vent

}

#[derive(Deserialize, Debug)]
struct Main 
{
    	temp: f64, //température
	humidity: u64,  // Pourcentage d'humidité
	pressure: u64,  // Pression en hPa (hectopascals)
	feels_like: Option<f64>,
}

#[derive(Deserialize, Debug)]
struct Wind 
{
    	speed: f64,  // Vitesse du vent en m/s
	deg: u16,  // Direction du vent nord, etc
}

#[derive(Deserialize, Debug)]
struct Weather 
{
    description: String,
}

#[derive(Deserialize, Debug)]
struct ForecastResponse {
    list: Vec<ForecastEntry>,
    city: City,
}

#[derive(Deserialize, Debug)]
struct ForecastEntry {
    dt_txt: String,
    main: Main,
    weather: Vec<Weather>,
    wind: Wind,
}

#[derive(Deserialize, Debug)]
struct City {
    name: String,
}


#[tokio::main]

async fn main() -> Result<(), Box<dyn Error>> 
{ 

	let home_dir = dirs::home_dir().expect("Impossible de trouver le fichier configuration");
    let tkt_path: PathBuf = home_dir.join("assistantbylseconf.tkt");

	if !tkt_path.exists() {
        if let Some(parent) = tkt_path.parent() {
            fs::create_dir_all(parent).expect("Erreur lors de la création du dossier");
        }

        let mut file = fs::File::create(&tkt_path).expect("Erreur lors de la création du fichier");
        writeln!(file,
    "Bienvenue sur le fichier de configuration de l'assistant Bylse\n\
\n\
afficher_le_logo = oui\n\
afficher_simulation_chargement = oui\n\
aide_vocale = non\n\
nom_de_l_assistant = Hélèna\n\
votre_nom = utilisateur\n\
afficher_la_meteo_au_demarrage = non\n\
ville_par_defaut = Paris
apikey =000000000000000"
).expect("Erreur lors de l’écriture des valeurs par défaut");

        println!("Le fichier assistantbylseconf.tkt a été créé à : {}", tkt_path.display());
    }
	
	
	let emoji = if is_windows_10() 
	{

        	"" // Pas d'emoji si c'est Windows 10
    	}
	else 
	{

        	"\u{2728}" // Emoji à utiliser si ce n'est pas Windows 10
    	};

	let config = lire_config(&tkt_path);
	
	 if config.get("afficher_le_logo").map(|v| v == "oui").unwrap_or(true) {
        afficher_logo();
    }

	if config.get("afficher_simulation_chargement").map(|v| v == "oui").unwrap_or(true) {
        afficher_chargement();
    }

	

	// Récupération du nom de l’assistant, avec fallback à "Héléna"
let nom_assistant = config
    .get("nom_de_l_assistant")
    .map(|val| val.trim().to_string())
    .filter(|val| !val.is_empty())
    .unwrap_or_else(|| "Héléna".to_string());

	let config = lire_config(&tkt_path);
let api_key = config.get("apikey").unwrap();

if api_key == "000000000000000" {
    eprintln!("⚠️  Aucune vraie clé API renseignée. La météo ne sera pas affichée.");
}

let machine_name = config
    .get("votre_nom")
    .map(|val| val.trim().to_string())
    .unwrap_or_else(|| "Utilisateur".to_string());
						
	let mut tts = Tts::default().unwrap();

	let vocal_enabled = match config.get("aide_vocale") {
    Some(val) if val == "oui" => true,
    _ => false,
};

if !vocal_enabled {
    println!("{}", " Aide vocale désactivée.".truecolor(255, 0, 0));
    println!();
}

let status_msg = check_update_on_start().await;

println!(
    "{} {}",
    "© 2025 LASSERRE URRUTY. Tous droits réservés. Assistant virtuel développée pour un usage personnel uniquement (v_l_1.0.6)."
        .truecolor(120, 120, 120),
    status_msg.truecolor(100, 180, 255)
);

	tts.set_rate(1.33).unwrap(); // Augmenter la vitesse (par exemple à 1.25x la vitesse normale)

   
   	let salutation = salutation_based_on_time();  // Appel de la fonction de salutation basée sur l'heure

	println!("{}",format!(" \n {} {}, bienvenue sur l'assistant Bylse !", salutation, machine_name).truecolor(0, 255, 0));
        // Récupérer les paramètres depuis la config
let afficher_meteo = match config.get("afficher_la_meteo_au_demarrage") {
    Some(val) if val == "oui" => true,
    _ => false,
};

let ville_par_defaut = config.get("ville").map(|s| s.as_str()).unwrap_or("Paris");

if afficher_meteo {
    // Si on affiche la météo au démarrage, on utilise la ville par défaut sans demander
    println!("{}", format!("\n {} {} {} Affichage automatique de la météo pour la ville : {}", emoji, nom_assistant, emoji, ville_par_defaut).truecolor(0, 255, 0));
    
    let texte = format!("Affichage automatique de la météo pour la ville : {}", ville_par_defaut);
    annoncer_vocalement(&texte, vocal_enabled, &mut tts);
    let city = "paris";
    get_weather(&nom_assistant, &ville_par_defaut, city, vocal_enabled, &mut tts).await?;
} 



   	let greetings = vec!  // Créer une liste de messages d'accueil
	[
							
 		"Commençons, que puis-je faire pour vous",
		"Bien, Que désirez-vous faire",
		"Parfait ! Comment puis-je vous assister aujourd'hui",
		"Bon choix ! Quels services puis-je vous offrir",
		"Et bien commençons veux tu ? Comment puis-je rendre votre journée meilleure",
		"Comment puis-je vous assister aujourd'hui",
		"Quels services puis-je vous offrir",
		"Et bien commençons ! Comment puis-je rendre votre journée meilleure",
		"Que puis-je faire pour améliorer votre expérience",
		"Je suis à votre service. Que désirez-vous savoir",
		"Quelles informations ou assistance puis-je vous fournir aujourd'hui",
		"Prêt à démarrer ? Dites-moi ce que je peux faire pour vous",
		"Quel sujet aimeriez-vous aborder",
		"Ravi de vous revoir ! Qu'est-ce qui vous amène aujourd'hui",
		"Comment puis-je vous être utile",
		"Quelles questions avez-vous en tête",
		"Que souhaitez-vous explorer avec moi",
		"Je suis là pour vous ! Quelles sont vos préoccupations",
		"Salut ! Alors, on commence ? Qu’est-ce que je peux faire pour toi aujourd’hui",
		"Heureux de te voir ! Quel est notre plan pour aujourd’hui",
		"C’est reparti ! Quelle est la mission du jour",
		"Toujours prêt ! Qu’est-ce qui te ferait plaisir maintenant",
		"Je suis tout ouïe ! Dis-moi ce dont tu as besoin",
		"Allons-y ! Quel objectif veux-tu atteindre maintenant",
		"Prêt à avancer ? Dis-moi ce que je peux faire pour t’aider",
		"Objectif en vue ! Par quoi commence-t-on",
		"Top départ ! Quelle est la première étape",
		"On attaque ? J’ai hâte de commencer",
		"Comment puis-je rendre votre journée plus productive",
		"Je suis à votre disposition pour toute demande",
		"Puis-je vous guider dans votre prochaine tâche",
		"Quelles sont vos priorités pour aujourd’hui",
		"Souhaitez-vous que je vous accompagne sur un sujet précis",
		"Je ne lis pas encore dans les pensées, alors parle-moi",
		"C’est le moment de me mettre au travail, chef",
		"J’ai affûté mes circuits, je suis prêt"
    	];

   
    	let greeting = greetings.choose(&mut rand::thread_rng()).unwrap(); // Choisir un message d'accueil au hasard
    
    	println!("{}", format!("\n {} ?", greeting).truecolor(0, 255, 0)); //affichage nom machine et de user
	
	 let texte = format!("{} {}",greeting, machine_name);
        		annoncer_vocalement(&texte, vocal_enabled, &mut tts);
    
 
    	let exit_messages = 
	[
        	"Merci d'avoir fait appel à moi, à bientôt !",
		"Au revoir ! En espérant que vous reviendrez vite",
		"Merci de m'avoir choisi, passez une belle journée !",
		"À la prochaine ! Prenez soin de vous",
		"Merci et à la prochaine fois !",
		"C’était un plaisir de vous aider, à très bientôt",
		"À très vite, et prenez bien soin de vous",
		"Merci pour cette conversation, revenez quand vous voulez",
		"Passez une excellente journée et à bientôt",
		"Au plaisir de vous revoir bientôt",
		"Mission accomplie ! À la prochaine",
		"On se retrouve bientôt pour de nouvelles aventures",
		"Merci et bonne continuation",
		"À bientôt, et que la productivité soit avec vous",
		"Je reste dans le coin si besoin, à plus tard"
   	];

	let _bite = [
   	"Néant.",
		"Infiniment petit.",
		"Une légende... mais dans l'autre sens.",
		"Invisible même avec un télescope.",
		"Plus abstrait que concret.",
		"Conceptuel, pas physique.",
		"Microscopique… et encore, je suis gentil.",
		"On a vu plus grand… chez les fourmis.",
		"Taille confidentielle, classée secret-défense.",
		"Format miniature de collection.",
		"Tellement petit qu'il échappe aux lois de la physique.",
		"Indétectable même par la NASA.",
		"Une entité quantique : là et pas là en même temps.",
		"Plus petit que le pixel d’un écran cassé.",
		"Une rumeur urbaine, mais sans preuves."
    	];

	

loop  //boucle
{	
		
       print!("\n {}", format!("{}: ", machine_name).blue().bold());

        io::stdout().flush().unwrap();

        let mut input = String::new();

        io::stdin().read_line(&mut input).expect("Erreur de lecture");

        let question = input.trim();
        
        // Stocker le résultat de `to_lowercase()` dans une variable
        let question_lowercase = question.to_lowercase();

	if question_lowercase.eq("quitter") || question_lowercase.eq("exit") 
		{
        		let mut rng = rand::thread_rng();

        		let message = exit_messages.choose(&mut rng).unwrap(); // Choisir un message aléatoire
        		
			println!("{}", format!("\n {} {}.", message, machine_name).truecolor(0, 255, 0));

			tts.set_rate(1.25).unwrap(); // Augmenter la vitesse (par exemple à 1.25x la vitesse normale)

			annoncer_vocalement(message, vocal_enabled, &mut tts);

			time::sleep(time::Duration::from_secs(6)).await;

       			break; 
		}

else if is_brand_query(&question_lowercase, "Bylse")
			{

const BYLSE_MSG: &str = r#"
Quentin Lasserre Urruty, né en 2003 à Dax, a grandi entre la région parisienne et les Landes avant de vivre quatre années marquantes à Pau, entre amitiés, skate et premières relations amoureuses. Après un changement de nom symbolique, il rejoint l’armée où il trouve discipline et rigueur.

Une expérience douloureuse à Rennes, marquée par de fausses accusations et une exclusion injuste, l’amène à se recentrer sur ses valeurs et à imaginer un projet éthique.

De cette vision est née Bylse, aujourd’hui marque déposée à l’INPI (validation officielle imminente), pensée comme un espace numérique éthique, libre et humain. Son objectif : proposer des outils simples, offrir des conseils, expliquer et guider vers un numérique plus respectueux, sans algorithmes opaques ni exploitation abusive des données personnelles.

Dans l'année 2028, Quentin prévoit de développer Bylse pour proposer des services payants de qualité, et devenir entrepreneur à part entière. Chaque solution Bylse sera conçue pour allier efficacité, respect de la vie privée et utilité concrète, afin de bâtir un environnement numérique plus sain et accessible à tous.
"#;

let wrapped_text = fill(BYLSE_MSG, 80); // 80 = largeur max des lignes

println!(
    "\n {}",
    format!("{} {} {}\n{}", emoji, nom_assistant, emoji, wrapped_text)
        .truecolor(200, 200, 200)
);

			}

			else if question_lowercase == "launcher" || question_lowercase == "mode l" {
    show_launcher();
}

			else if is_update_command(&question_lowercase) {
    let url = "https://magasin.bylse.app/site/assistantbylse/ressources/AssistantBylseWindows.zip";
    let dest = default_download_path();

    println!(
        "\n {}",
        format!("{} {} {} Téléchargement de la mise à jour en cours…", emoji, nom_assistant, emoji)
            .truecolor(100, 180, 255)
    );
    let texte = "Téléchargement de la mise à jour en cours";
    annoncer_vocalement(&texte, vocal_enabled, &mut tts);

    match download_file(url, &dest).await {
        Ok(_) => {
            println!(
                "\n {}",
                format!(
                    "{} {} {} Terminé ! Fichier enregistré dans : {}",
                    emoji,
                    nom_assistant,
                    emoji,
                    dest.display()
                )
                .truecolor(0, 255, 0)
            );
            let texte = "Téléchargement terminé";
            annoncer_vocalement(&texte, vocal_enabled, &mut tts);

            // Optionnel : ouvrir le dossier de téléchargement sur Linux
            #[cfg(target_os = "linux")]
            {
                if let Some(parent) = dest.parent() {
                    let _ = std::process::Command::new("xdg-open")
                        .arg(parent)
                        .spawn();
                }
            }
        }
        Err(e) => {
            println!(
                "\n {}",
                format!("{} {} {} Erreur pendant la mise à jour : {}", emoji, nom_assistant, emoji, e)
                    .truecolor(255, 85, 85)
            );
            let texte = "Erreur pendant la mise à jour";
            annoncer_vocalement(&texte, vocal_enabled, &mut tts);
        }
    }
}


else if is_forecast_question(&question_lowercase) {
    let city = extract_city_name_simple(&question_lowercase);

    if city.is_empty() {
        println!("{}", "Ville introuvable dans la requête. Exemple: « météo sur 5 jours Pau »".truecolor(255, 85, 85));
    } else if is_detailed_forecast(&question_lowercase) {
        // DÉTAILLÉ (toutes les 3h)
        get_forecast_detailed(
            &city,
            api_key,
            &nom_assistant,
            extract_days,
            &question_lowercase
        ).await?;
    } else {
        // SIMPLE (midi uniquement)
        get_forecast_filtered(
            &city,
            api_key,
            3,
            &nom_assistant,
            extract_days,
            &question_lowercase
        ).await?;
    }
}


     	else if is_weather_question(&question_lowercase) 
		{

    			let city = extract_city_name(&question_lowercase);

    			get_weather(&nom_assistant, &ville_par_defaut, &city, vocal_enabled, &mut tts).await?;  // Obtenir la météo
        	} 
  	 
	else if question_lowercase.contains("heure") 
		{

            		get_time(&nom_assistant);  // Obtenir l'heure
			
        	}
	else if question_lowercase.contains("lance ") || question_lowercase.contains("lance moi ") 
		{
        		launch_application(&question_lowercase); // Lancer l'application
			let pause_duration = time::Duration::from_secs(2);
        		thread::sleep(pause_duration);
		}

	else if taille_bite(question) 
		{
			let mut rng = rand::thread_rng();
            		let bite = _bite.choose(&mut rng).unwrap();
			println!("\n {}", format!("{} {} {} {}", emoji, nom_assistant, emoji, bite).truecolor(255, 255, 0));
			 let texte = format!("{}",bite);
        		annoncer_vocalement(&texte, vocal_enabled, &mut tts);
		} 
	else if question_lowercase.eq("aide") || question_lowercase == "?" 
		{
       			println!("\n {}", format!("{} {} {} Génération de la page d'aide...", emoji, nom_assistant, emoji).truecolor(255, 255, 0));
			let texte = "Génération de la page d'aide";
        		annoncer_vocalement(&texte, vocal_enabled, &mut tts);
			time::sleep(time::Duration::from_secs(3)).await;
        		generer_page_aide(); // Appeler la fonction pour générer la page web
		}
	 else if question_lowercase.contains("+") || question_lowercase.contains("-") || question_lowercase.contains("*")  || question_lowercase.contains("/") 
		{
    
   			let expression_normalisee = normaliser_expression(&question_lowercase); // Normaliser l'expression pour ajouter les espaces autour des opérateurs
   			// Vérifier si l'expression normalisée contient des opérateurs valides
    			if expression_normalisee.contains("+")|| expression_normalisee.contains("-")|| expression_normalisee.contains("*")|| expression_normalisee.contains("/")
			{
        
        			match effectuer_calcul(&expression_normalisee) // Passer l'expression normalisée à la calculatrice
				{
            				Err(erreur) => println!("\n {}", format!("{} {} {} Il y a une erreur {}", emoji, nom_assistant, emoji,erreur).truecolor(255, 255, 0)),
					Ok(resultat) => println!("\n {}", format!("{} {} {} Voici le résultat à votre calcul : {} = {}",emoji, nom_assistant, emoji, expression_normalisee, 						resultat).truecolor(255, 255, 0)),
        			}
    			}
		}
	
              else
		{
			println!("\n {}", format!("{} {} {} Désolé mais votre saisie est erronée. Voulez-vous que je recherche sur Internet ? (o/n)", emoji, nom_assistant, emoji).truecolor(255, 255, 0));


			let texte = "Désolé mais votre saisie est eronne. Voulez-vous que je recherche sur Internet ? (o/n)";
        		annoncer_vocalement(&texte, vocal_enabled, &mut tts);

				 print!("\n {}: ", machine_name.blue().bold());
std::io::stdout().flush().unwrap();

    let mut confirmation = String::new();
    std::io::stdin().read_line(&mut confirmation).expect("Erreur lecture confirmation");
    let confirmation = confirmation.trim().to_lowercase();

    if confirmation == "o" || confirmation == "oui" {

    println!("\n {}", format!("{} {} {} Parfait. Je lance une recherche sur le navigateur.", emoji, nom_assistant, emoji).truecolor(100, 180, 255));

    let texte = " Parfait. Je lance une recherche sur le navigateur.";
    annoncer_vocalement(&texte, vocal_enabled, &mut tts);

    time::sleep(time::Duration::from_secs(5)).await;

    let search_url = format!("https://duckduckgo.com/?q={}", question);

    if webbrowser::open(&search_url).is_ok() {
        println!("\n {}", format!("{} {} {} J'espère que vous trouverez ce que vous cherchez !", emoji, nom_assistant, emoji).truecolor(100, 180, 255));
        let texte = "J'espère que vous trouverez ce que vous cherchez !";
        annoncer_vocalement(&texte, vocal_enabled, &mut tts);
    } else {
        println!("\n {}", format!("{} {} {} Impossible d'ouvrir le navigateur.", emoji, nom_assistant, emoji).truecolor(255, 0, 0));
        let texte = "Impossible d'ouvrir le navigateur";
        annoncer_vocalement(&texte, vocal_enabled, &mut tts);
    }

} else if confirmation == "n" || confirmation == "non" {
    // Ne pas lancer la recherche

} else {
	println!("\n {}", format!("{} {} {} Merci de répondre par 'o' (oui) ou 'n' (non).", emoji, nom_assistant, emoji).truecolor(255, 85, 85));
    // La boucle continue et repose la question
}
        }
}


    Ok(())
}

fn is_forecast_question(question: &str) -> bool {
    let q = question.to_lowercase();

    q.contains("prévisions météo") ||
    q.contains("prévisions météo à") ||
    q.contains("météo sur 3 jours") ||
    q.contains("météo sur 5 jours") ||
    q.contains("prévision météo") ||
    q.contains("météo pour les prochains jours") ||
    q.contains("météo à ") && (q.contains("3 jours") || q.contains("5 jours") || q.contains("plusieurs jours")) ||
    q.contains("quel temps fera-t-il") ||
    q.contains("temps prévu") ||
    q.contains("temps pour les prochains jours") ||
    q.contains("quelle météo sur plusieurs jours")
}

fn is_weather_question(question: &str) -> bool 
	{
     		question.contains("quelle est la météo de") ||
		question.contains("donne moi la météo de") ||
		question.contains("donne la météo de") ||
		question.contains("quelle est la météo à") ||
		question.contains("dis moi la météo de") ||
		question.contains("quelle météo à") ||
		question.contains("météo à") ||
 		question.contains("météo sur") ||
		question.contains("météo de") ||
    		question.contains("météo")  
	 
	}

	   fn extract_days(question: &str) -> usize {
    if question.contains("5 jours") {
        5
    } else if question.contains("3 jours") {
        3
    } else {
        3 // par défaut, si pas précisé
    }
}

fn extract_city_name(question: &str) -> String {
    let mut city = question.to_lowercase();

    // Supprimer les mentions de durée (sur X jours, pour X jours)
    for days in 1..=10 {
        city = city.replace(&format!("sur {} jours", days), "");
        city = city.replace(&format!("pour {} jours", days), "");
    }



    // Supprimer les expressions génériques
    let patterns = [
        "quelle est la météo de ",
        "dis moi la météo de ",
        "quelle est la météo à ",
        "donne la météo de ",
        "donne moi la météo de ",
        "quelle météo à ",
        "météo de ",
        "météo à ",
        "météo sur ",
        "météo ",
        "prévisions météo ",
        "prévision météo ",
        "prévisions ",
        "prévision ",
        "à moyen terme",
        "pour les prochains jours",
        "dans les prochains jours",
    ];

    for pat in &patterns {
        city = city.replace(pat, "");
    }

    city = city.trim().to_string();

    if city.is_empty() {
        return String::new();
    }

    city
}


async fn get_weather(nom_assistant: &str,
    _ville_par_defaut: &str,
    city: &str,
    vocal_enabled: bool,
    tts: &mut Tts) -> Result<(), Box<dyn Error>> 
	{
    


		let _emoji = if is_windows_10() 
		{

        		"" // Pas d'emoji si c'est Windows 10
    		}
		else 
		{

        		"\u{2728}" // Emoji à utiliser si ce n'est pas Windows 10
    		};

    		let api_key = "c59dc97190873b83d5e5fef017d28a7d"; // Remplace par ta clé OpenWeatherMap

    		let units = "metric"; // 'metric' pour les degrés Celsius

    		let url = format!("http://api.openweathermap.org/data/2.5/weather?q={}&appid={}&units={}",city, api_key, units);  // URL de l'API OpenWeatherMap

     	  	let response = reqwest::get(&url).await;  // Effectuer la requête HTTP avec gestion d'erreurs explicite

    		match response 
			{
        		Ok(res) => 
				{
            			if res.status().is_success() 
					{
                				let weather_data = res.json::<WeatherResponse>().await;

                				match weather_data {
                    			Ok(weather) => 
					{
                        			println!("\n {}", format!("Météo actuelle pour {} :", weather.name).truecolor(50, 145, 100));
						let texte = format!("Météo actuelle pour {} :", weather.name);
						annoncer_vocalement(&texte, vocal_enabled, tts);
						println!("\n {}", format!("Température : {}°C", weather.main.temp).truecolor(50, 145, 100));
						let texte = format!("Température : {}°Celsius", weather.main.temp);
						annoncer_vocalement(&texte, vocal_enabled, tts);

fn translate_weather_description(description: &str) -> String 
{
	let _emoji = if is_windows_10() 
	{

        	"" // Pas d'emoji si c'est Windows 10
    	}
	else 
	{

        	"\u{2728}" // Emoji à utiliser si ce n'est pas Windows 10
    	};

    	match description.to_lowercase().as_str() 
	{

        	"clear sky" => "ciel dégagé ☀️".to_string(),
        	"few clouds" => "quelques nuages 🌤️".to_string(),
        	"scattered clouds" => "nuages dispersés 🌥️".to_string(),
        	"broken clouds" => "nuages fragmentés ☁️".to_string(),
        	"shower rain" => "pluie d'averse 🌧️".to_string(),
        	"rain" => "pluie 🌧️".to_string(),
        	"thunderstorm" => "orage ⛈️".to_string(),
        	"snow" => "neige ❄️".to_string(),
        	"mist" => "brume 🌫️".to_string(),
		"overcast clouds" => "couvert ☁️".to_string(),
		"wind" => "vent 💨".to_string(),
		"sunny" => "ensoleillé ☀️".to_string(),
		"moderate rain" => "pluie modéré 🌧️".to_string(),
		"light rain"=> "petite pluie 🌧️".to_string(),
       		_ => description.to_string(), // Retourne la description originale si elle n'est pas trouvée
    	}
}

println!("\n {}", format!("Description : {}", translate_weather_description(&weather.weather[0].description)).truecolor(50, 145, 100));

println!("\n {}", format!("Humidité : {}%", weather.main.humidity).truecolor(50, 145, 100));

println!("\n {}", format!("Pression : {} hPa", weather.main.pressure).truecolor(50, 145, 100));

println!("\n {}", format!("Vitesse du vent : {} m/s", weather.wind.speed).truecolor(50, 145, 100));

println!("\n {}", format!("Direction du vent : {}°", weather.wind.deg).truecolor(50, 145, 100));



let texte = format!("Description : {}\nHumidité : {}%\nPression : {} hPa\nVitesse du vent : {} mètre par seconde\nDirection du vent : {}°",
translate_weather_description(&weather.weather[0].description),
weather.main.humidity,
weather.main.pressure,
weather.wind.speed,
weather.wind.deg);
let texte_sans_emoji = supprimer_emojis(&texte);
annoncer_vocalement(&texte_sans_emoji, vocal_enabled, tts);			

                    }
                    Err(e) => println!("\n {}", format!("{} {} {}  Erreur lors de la conversion du JSON : {:?}", _emoji, nom_assistant, _emoji, e).red()),
			
                }
            } else {
                println!("\n {}", format!("{} {} {} Impossible de trouver la ville '{}'. Statut : {}", _emoji, nom_assistant, _emoji, city, res.status()).red());
            }
        }
        	Err(e) => 
			{

			if e.is_connect() 
				{
        
					println!("\n {}", format!("{} {} {} Erreur : impossible de se connecter à Internet. Vérifiez votre connexion.",_emoji, nom_assistant, _emoji).truecolor(255, 0, 0));
					
 				
    				} 
				else 
				{
        
        				println!("\n {}", format!("{} {} {} Erreur lors de la requête HTTP : {:?}",_emoji, nom_assistant, _emoji, e).red());
					
    				}
			}
    	}

    Ok(())
}


async fn get_forecast_filtered(city: &str, api_key: &str, days: usize, nom_assistant: &str, extract_days: fn(&str) -> usize, question: &str) -> Result<(), Box<dyn std::error::Error>> {
    let units = "metric";
    let url_forecast = format!(
        "http://api.openweathermap.org/data/2.5/forecast?q={}&appid={}&units={}&lang=fr",
        city, api_key, units
    );

fn translate_weather_description(description: &str) -> String {
    // utilise ta fn normalize(...) déjà présente
    let d = normalize(description);

    // ciel dégagé
    if d.contains("ciel degage") || d.contains("clear sky") {
        return "ciel dégagé ☀️".to_string();
    }

    // nuages (peu / quelques / épars / partiellement / nuageux / overcast)
    if d.contains("peu nuageux") || d.contains("quelques nuages") || d.contains("few clouds") {
        return "peu nuageux 🌤️".to_string();
    }
    if d.contains("nuages disperses") || d.contains("scattered clouds") || d.contains("partiellement nuageux") {
        return "nuages épars 🌥️".to_string();
    }
    if d.contains("nuages fragmentes") || d.contains("broken clouds") || d.contains("nuageux") {
        return "nuageux ☁️".to_string();
    }
    if d.contains("couvert") || d.contains("overcast clouds") {
        return "couvert ☁️".to_string();
    }

    // pluie
    if d.contains("legere pluie") || d.contains("pluie faible") || d.contains("light rain") {
        return "légère pluie 🌦️".to_string();
    }
    if d.contains("pluie moderee") || d.contains("moderate rain") || d.contains("pluie") {
        return "pluie 🌧️".to_string();
    }
    if d.contains("forte pluie") || d.contains("heavy rain") {
        return "forte pluie 🌧️💧".to_string();
    }
    if d.contains("averse") || d.contains("shower") {
        return "averses 🌧️".to_string();
    }

    // orage / neige / brume
    if d.contains("orage") || d.contains("thunderstorm") {
        return "orage ⛈️".to_string();
    }
    if d.contains("neige") || d.contains("snow") {
        return "neige ❄️".to_string();
    }
    if d.contains("brume") || d.contains("brouillard") || d.contains("mist") || d.contains("fog") {
        return "brume 🌫️".to_string();
    }

    // fallback : on renvoie la description d'origine (avec accents) telle quelle
    description.to_string()
}

let days = extract_days(&question);

let emoji = if is_windows_10()
	{

        	"" // Pas d'emoji si c'est Windows 10
    	}
	else
	{

        	"\u{2728}" // Emoji à utiliser si ce n'est pas Windows 10
    	};

    let resp = reqwest::get(&url_forecast).await?;
    if !resp.status().is_success() {
        println!("Erreur lors de la récupération des prévisions : {}", resp.status());
        return Ok(());
    }

    let forecast: ForecastResponse = resp.json().await?;

	println!();

     println!("{}", format!(" Prévisions météo pour {} :\n ", forecast.city.name)
        .truecolor(50, 145, 100));



let mut temps_jours: HashMap<String, (f64, f64)> = HashMap::new();

// 1. Calcul min/max par date
for entry in &forecast.list {
    let date = &entry.dt_txt[..10];
    let temp = entry.main.temp;

    let entry_temp = temps_jours.entry(date.to_string()).or_insert((temp, temp));
    if temp < entry_temp.0 {
        entry_temp.0 = temp;
    }
    if temp > entry_temp.1 {
        entry_temp.1 = temp;
    }
}

let mut dates_affichees = HashSet::new();

// 2. Affichage seulement pour heure 12:00:00
for entry in &forecast.list {
    let date = &entry.dt_txt[..10];
    let heure = &entry.dt_txt[11..19];

    if !dates_affichees.contains(date) {
        // temps_jours contient forcément la date ici
        let (min_temp, max_temp) = temps_jours.get(date).unwrap();

        let temp_colored = format!("{:.1}°C (min {:.1}°C / max {:.1}°C)", entry.main.temp, min_temp, max_temp)
            .truecolor(255, 165, 0).bold();

        let desc = translate_weather_description(&entry.weather[0].description);

        println!(
            "{} : {}, {}\n",
            date.truecolor(150, 150, 150),
            temp_colored,
            desc.truecolor(50, 145, 100)
        );



        dates_affichees.insert(date.to_string());
        if dates_affichees.len() == days {
            break;
        }
    }
}

    Ok(())
}

fn get_time(nom_assistant: &str) 
{

	let emoji = if is_windows_10() 
	{

        	"" // Pas d'emoji si c'est Windows 10
    	}
	else 
	{

        	"\u{2728}" // Emoji à utiliser si ce n'est pas Windows 10
    	};

    	let now = Local::now(); // Obtenir l'heure locale

    println!("\n {}", format!("{} {} {} L'heure actuelle est {}",emoji,nom_assistant, emoji, now.format("%H:%M:%S")).truecolor(145, 255, 145));
	
	 
}


fn launch_application(command: &str) 
{
  
	let app_name = command
    		.replace("lance moi ", "")
    		.replace("lance ", "")
    		.trim()
    		.to_string();

    	let extension = ".exe"; // Assurez-vous de garder l'extension

	if app_name.to_lowercase() == "discord" 
	{

    	let discord_path = "C:\\Users\\firef\\AppData\\Local\\Discord\\app-1.0.9166\\Discord.exe";

	let _output = Command::new(discord_path)
        	.stdout(Stdio::null())  // Ignore la sortie standard
        	.stderr(Stdio::null())  // Ignore la sortie d'erreur
		.creation_flags(0x08000000) // CREATE_NO_WINDOW
        	.spawn();  // Exécute le processus 

   	match Command::new(discord_path).spawn() 
	{
       		Ok(mut child) => 
		{

            		println!("L'application Discord a été lancée avec succès.");

            
           	 match child.try_wait() // Vérifier si Discord tourne bien après le lancement
		{
                Ok(Some(status)) => 
		{
               	if status.success() 
			{

                        	println!("Discord a démarré correctement.");
				
                    	}
 
		else 
			{

                        	println!("Discord a rencontré un problème au démarrage.");
                    	}
                }
                Ok(None) => 
		{
                    println!("Discord est en cours d'exécution.");
                }
                Err(e) => 
		{
                    println!("Erreur lors du suivi du processus Discord: {}", e);
                }
            }
        }

        Err(e) => 
	{
            println!("Erreur lors du lancement de Discord: {}", e);
        }
    }


    return;
}

	let search_paths = vec![ // Définir les disques et chemins à explorer
	"A:\\","B:\\","C:\\Program Files","C:\\Program Files (x86)","C:\\Windows\\System32","D:\\","E:\\","F:\\","G:\\","H:\\","I:\\","J:\\","K:\\","L:\\","M:\\",
	"N:\\","O:\\","P:\\", "Q:\\", "R:\\", "S:\\", "T:\\", "U:\\", "V:\\", "W:\\", "X:\\","Y:\\", "Z:\\", "C:\\Users\\firef\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs", ];

    	let mut found = false;

    	fn search_in_directory(path: &Path, app_name: &str, extension: &str) -> Option<PathBuf>  // Fonction pour parcourir récursivement les dossiers
	{
        
	if let Ok(entries) = fs::read_dir(path) 
		{
            		for entry in entries.filter_map(Result::ok) 
				{

               	 			let file_name = entry.file_name().into_string().unwrap_or_default();

                			let file_path = entry.path();

                			if file_path.is_dir() // Vérifie si c'est un dossier
						{

                    					if let Some(found_path) = search_in_directory(&file_path, app_name, extension) 
								{

                        						return Some(found_path); // Retourne le chemin trouvé
                    						}
                				} 

						else if file_name.to_lowercase() == format!("{}{}", app_name.to_lowercase(), extension) && file_name.ends_with(".exe") 
							{
               							return Some(file_path); // Retourne le chemin du fichier trouvé
            						}
            			}
        }

        None
}

  		let uwp_apps = vec!["netflix", "horloge", "calculatrice", "météo", "musique", "photos", "film", "cartes", "store"]; // Ajoute d'autres noms d'applications 																		UWP si nécessaire
    		if uwp_apps.contains(&app_name.to_lowercase().as_str()) 
		{

        		let app_uri = match app_name.to_lowercase().as_str() 
			{

            		"netflix" => "ms-windows-store://pdp/?ProductId=9nblggh3z1qf", // URI pour Netflix
            		"horloge" => "ms-clock://", // URI pour l'application Horloge
            		"calculatrice" => "calc://", // URI pour l'application Calculatrice
            		"météo" => "ms-weather://", // URI pour l'application Météo
            		"musique" => "ms-music://", // URI pour l'application Musique
            		"photos" => "ms-photos://", // URI pour l'application Photos
            		"film" => "ms-film://", // URI pour l'application Films et TV
            		"cartes" => "ms-maps://", // URI pour l'application Cartes
            		"store" => "ms-windows-store://", // URI pour l'application Microsoft Store
            		_ => return, // Si ce n'est pas une application connue, on ne fait rien
        	};

        match Command::new("explorer")
            .arg(app_uri)
            .spawn() 
		{	
            Ok(_) => 
		{

                	println!("L'application '{}' a été lancée avec succès.", app_name);

                	return;
            	}

            	Err(e) => 
			{
	
                		println!("Erreur lors du lancement de l'application '{}': {}", app_name, e);
                		
				return;
            		}
        	}
    }
   

for path in search_paths 
{
        if let Some(app_path) = search_in_directory(Path::new(path), &app_name, extension) 
		{

			println!("Tentative de lancement de l'application à : {:?}", app_path);

            		match Command::new(&app_path).spawn() 
				{
                			Ok(_) => 
						{

                    					println!("L'application '{}' a été lancée avec succès.", app_path.display());

                    					found = true;
                				},

               		Err(e) => println!("Erreur lors du lancement de l'application '{}': {}", app_path.display(), e),
            	}

            break; // On a trouvé l'application, pas besoin de continuer à chercher
        }
    }

    if !found {
        println!("Aucune application trouvée pour '{}'", app_name);
    }
}

fn salutation_based_on_time() -> String // Fonction de salutation en fonction de l'heure

{
    let current_hour = Local::now().hour();
    if current_hour >= 6 && current_hour < 18 {
        "Bonjour".to_string()
    } else {
        "Bonsoir".to_string()
    }
}

fn is_windows_10() -> bool 
{
   
    	if cfg!(windows)  // Vérifie si l'OS est Windows
	{
        
        	if let Ok(version) = env::var("OS") // Obtient la version de Windows
		{
            
            		return version.contains("Windows 10"); // Vérifie si la version contient "Windows 10"
        	}
    	}

    false
}

fn taille_bite(question: &str) -> bool 
{
    question.contains("quelle est la taille de ma bite") || question.contains("donne moi la taille de ma bite")
}


fn generer_page_aide()
{
    let contenu = r#"
    <!DOCTYPE html>
    	<html lang="fr">
    		<head>
    			<meta charset="UTF-8">
   				 <meta name="viewport" content="width=device-width, initial-scale=1.0">
    					<title>Aide - Assistant Bylse</title>
        					<style>
          						body
								{
									background-color: #000000; /* Fond noir */
                							font-family: Arial, sans-serif;
                							line-height: 1.6;
               								margin: 20px;
                							color: #FFFFFF;
            							}
          						h1 {color: #00FF00;}
							h2 {color: #1E90FF;}
          						ul {margin: 20px 0;
               						padding-left: 20px;}
            						li {margin-bottom: 10px;}
 							lb {margin-bottom: 5px;}

        					</style>
    		</head>
    		<body>
    <h1>Bienvenue dans l'aide de l'assistant Bylse</h1>
    <p>Voici une liste des fonctionnalités disponibles et des conseils pour interagir avec moi :</p>

    <h2>Fonctionnalités :</h2>
    <ul>
        <li><strong>Météo :</strong> Tapez 'météo' suivi de votre ville pour obtenir la météo en temps réel.</li>
        <li><strong>Prévisions météo :</strong> Tapez "prévisions météo" suivi de votre ville pour obtenir les prévisions sur 3 jours. Pour les prévisions de 5 jours (ou 3 jours) tapez "météo sur 5 jours" suivi de votre ville</li>
        <li><strong>Prévisions détaillées sur 3 jours :</strong> Tapez "prévision météo détaillé " suivi de votre ville pour obtenir les prévisions détaillées pour les 3 prochains jours.(une mise à jour viendra rajouter pour 5 jours)</li>
        <li><strong>Heure :</strong> Tapez 'heure' et l'assistant vous donnera l'heure actuelle.</li>
        <li><strong>Lancement d'application :</strong> Tapez 'lance' suivi de votre application pour l'exécuter sans la chercher partout. Attention certaines applications comme Netflix ne sont pas supportées.(soucis avec la version linux en cours de patch)</li>
        <li><strong>Quitter :</strong> Tapez 'quitter' ou 'exit' pour fermer l'application.</li>
        <li><strong>Calcul :</strong> Tapez un calcul simple (soustraction, division, multiplication et addition). L'assistant s'occupe du reste.</li>
        <li><strong>Mode Launcher :</strong> Tapez 'launcher' ou 'mode l' pour afficher la liste des projets Bylse avec les liens vers leurs sites. Vous pouvez ensuite choisir un projet pour l'ouvrir directement.</li>
        <li><strong>Mode mise à jour :</strong> Tapez 'update', 'upgrade', 'mise à jour' ou 'mettre à jour' pour télécharger une mise à jours.</li>
        <li><strong>Fichier de configuration :</strong> Un fichier de configuration est disponible pour améliorer l'expérience utilisateur en personnalisant certaines fonctionnalités.</li>
    </ul>

    <h2>Conseils d'utilisation :</h2>
    <ul>
        <li>Formulez vos questions de manière claire et concise.</li>
        <li>Utilisez des mots-clés simples pour activer les fonctionnalités.</li>
        <li>N'hésitez pas à explorer les différentes commandes disponibles.</li>
        <li>Pas de stress ! Si je ne comprends pas, je lance la recherche pour vous.</li>
    </ul>

    <h2>Fonctionnalités futures :</h2>
    <ul>
        <li>Plus de fonctionnalités sur l’heure, la météo ainsi que des dialogues mieux formés.</li>
        <li>Possibilité d’afficher/générer une image.</li>
        <li>Dans le meilleur des cas, énoncer vocalement les résultats.</li>
        <li>Interactivité Améliorée : Un système de chat où l'utilisateur peut poser plusieurs questions à la suite, et l'assistant garde le contexte de la conversation.</li>
        <li>Ajout d'Autres Sources d'Information : Intégration d'API pour fournir des informations complémentaires comme des actualités locales, des recommandations d'activités selon la météo, ou des alertes météorologiques.</li>
        <li>Visualisation des Données : Graphiques ou visualisations pour montrer les tendances météorologiques, en utilisant une interface graphique ou une sortie dans un navigateur.</li>
        <li>Réponses Humoristiques ou Personnalisées : Ajout de personnalités et d’humour dans les réponses de l'assistant, en fonction de l'historique de l'utilisateur.</li>
        <li>Notifications Météorologiques : Système de notifications pour informer l'utilisateur des changements météorologiques significatifs (comme des alertes de tempête).</li>
        <li>Entraînement du Modèle de Langage pour améliorer la compréhension des requêtes.</li>
        <li>Fonctionnalités supplémentaires comme : "calcul de meilleur itinéraire", "coach de sport", "coach nutritif", "créateur de script".</li>
        <li>Intégration multiplateforme : Linux, Mac, iPhone, Android.</li>
        <li>Ajout d’une fonction pour parler et une fonction pour écouter.</li>
    </ul>

    <p>Merci d'avoir choisi l'assistant Bylse !</p>
    		</body>
    </html>

"#;
   
    let mut fichier = File::create("aide.html").expect("Impossible de créer le fichier"); // Créer un fichier HTML
    fichier.write_all(contenu.as_bytes()).expect("Erreur d'écriture dans le fichier");

	if cfg!(target_os = "windows") // Ouvrir dans le navigateur
	{
        Command::new("cmd")
            .args(&["/C", "start", "aide.html"])
            .spawn()
            .expect("Impossible d'ouvrir la page web");
    	} 

	else if cfg!(target_os = "macos") 
	{
        Command::new("open")
            .arg("aide.html")
            .spawn()
            .expect("Impossible d'ouvrir la page web");
    	} 
	else if cfg!(target_os = "linux") 
	{
        Command::new("xdg-open")
            .arg("aide.html")
            .spawn()
            .expect("Impossible d'ouvrir la page web");
    	}
}


fn afficher_logo() {
    let logo = r#"
     ██╗  ██╗███████╗██╗     ███████╗███╗   ██╗ █████╗ 
     ██║  ██║██╔════╝██║     ██╔════╝████╗  ██║██╔══██╗
     ███████║█████╗  ██║     █████╗  ██╔██╗ ██║███████║
     ██╔══██║██╔══╝  ██║     ██╔══╝  ██║╚██╗██║██╔══██║
     ██║  ██║███████╗███████╗███████╗██║ ╚████║██║  ██║
     ╚═╝  ╚═╝╚══════╝╚══════╝╚══════╝╚═╝  ╚═══╝╚═╝  ╚═╝
            Bienvenue dans l'assistant Bylse
    "#;

    let mut rng = rand::thread_rng(); // Générer des couleurs aléatoires
    let r = rng.gen_range(0..=255);
    let g = rng.gen_range(0..=255);
    let b = rng.gen_range(0..=255);

    
    println!("{}", logo.truecolor(r, g, b)); // Afficher le logo avec une couleur aléatoire

    
    
	}

fn afficher_chargement() {

	let message_base = "Chargement de l'assistant Bylse"; // Texte de base
    let dots = ["", ".", "..", "..."]; // Points pour l'animation

	for i in 0..dots.len() // Animation des points 
	{
        	print!("\r{}{}", message_base, dots[i]); // Réimprime la ligne complète avec les points
        	std::io::stdout().flush().unwrap(); // Force l'affichage immédiat
        	thread::sleep(Duration::from_millis(1000)); // Pause entre chaque étape
    	}

    // Effacer complètement la ligne
    let total_length = message_base.len() + dots[dots.len() - 1].len(); // Longueur totale de la ligne
    print!("\r{}\r", " ".repeat(total_length)); // Efface la ligne en imprimant des espaces
    std::io::stdout().flush().unwrap(); }

fn effectuer_calcul(expression: &str) -> Result<f64, &'static str> 
	
	{
   		let tokens: Vec<&str> = expression.split_whitespace().collect();

    		if tokens.len() != 3 
		{
        		return Err("Veuillez entrer une expression sous la forme : nombre1 opérateur nombre2 (ex : 5 + 3)");
    		}

    		let num1: f64 = tokens[0].parse().map_err(|_| "Le premier nombre n'est pas valide")?;
   		let num2: f64 = tokens[2].parse().map_err(|_| "Le deuxième nombre n'est pas valide")?;
    		let operateur = tokens[1];
	

    		match operateur 
		{
        		"+" => Ok(num1 + num2),
        		"-" => Ok(num1 - num2),
        		"*" => Ok(num1 * num2),
        		"/" => 
			{
            		if num2 == 0.0 
				{
                			Err("Division par zéro impossible")
            			} 
			else 
				{
                			Ok(num1 / num2)
            			}
        		}

        		_ => Err("Opérateur non supporté. Utilisez +, -, * ou /"),
   		}
}

fn normaliser_expression(input: &str) -> String 
{
    
    input  // Ajoute des espaces autour des opérateurs
        .replace("+", " + ")
        .replace("-", " - ")
        .replace("*", " * ")
        .replace("/", " / ")
        .split_whitespace()
        .collect::<Vec<_>>()
        .join(" ") // Nettoie les espaces multiples
}

fn annoncer_vocalement(texte: &str, vocal_enabled: bool, tts: &mut Tts) {
    if vocal_enabled
	{
        tts.speak(texte, false).unwrap();
    	}
}

fn supprimer_emojis(texte: &str) -> String 
{
    texte.chars()
        .filter(|c| !c.is_emoji())
        .collect()
}

trait EmojiCheck // Ajoute cette méthode à `char` pour détecter les emojis
{
    fn is_emoji(&self) -> bool;
}

impl EmojiCheck for char 
{
    fn is_emoji(&self) -> bool 
	{
        	let code = *self as u32;
        	(code >= 0x1F600 && code <= 0x1F64F) || // Emoticons
        	(code >= 0x1F300 && code <= 0x1F5FF) || // Symbols & Pictographs
        	(code >= 0x1F680 && code <= 0x1F6FF) || // Transport & Map Symbols
        	(code >= 0x2600 && code <= 0x26FF) ||   // Miscellaneous Symbols
        	(code >= 0x2700 && code <= 0x27BF)      // Dingbats
    	}
}

fn lire_config(path: &std::path::Path) -> HashMap<String, String> {
    let file = fs::File::open(path).expect("Impossible d’ouvrir le fichier de config");
    let reader = BufReader::new(file);
    let mut config = HashMap::new();

    for line_res in reader.lines() {
        let line = line_res.expect("Erreur lecture ligne");
        let line = line.trim();

        // Ignorer lignes vides ou lignes de bienvenue
        if line.is_empty() || line.starts_with("Bienvenue") {
            continue;
        }

        // Extraire clé/valeur format "clé = valeur"
        if let Some((key, value)) = line.split_once('=') {
            config.insert(
                key.trim().to_lowercase().replace(' ', "_"),
                value.trim().to_lowercase(),
            );
        }
    }

    config
}

fn normalize(s: &str) -> String {
    // minuscules + supprime les accents/diacritiques + compresse espaces
    let no_diacritics: String = s
        .nfd() // décompose
        .filter(|c| !is_combining_mark(*c)) // retire les diacritiques
        .collect::<String>()
        .to_lowercase();

    // remplace tous les espaces multiples par un seul espace
    let mut out = String::with_capacity(no_diacritics.len());
    let mut prev_space = false;
    for ch in no_diacritics.chars() {
        if ch.is_whitespace() {
            if !prev_space {
                out.push(' ');
            }
            prev_space = true;
        } else {
            out.push(ch);
            prev_space = false;
        }
    }
    out.trim().to_string()
}

// --- 1) L’utilisateur demande-t-il une prévision détaillée ? ---
fn is_detailed_forecast(question: &str) -> bool {
    let q = normalize(question);
    // couvre: détaillé, detaill(e), detaille, heure par heure, etc.
    q.contains("detail")            // "detail", "detaille", "detaillee", "detailler" (après normalisation)
        || q.contains("heure par heure")
        || q.contains("toutes les heures")
        || q.contains("complet")
        || q.contains("complete")
}

// --- 2) Extraire une VILLE propre (dernier mot non parasite) ---
fn extract_city_name_simple(question: &str) -> String {
    use std::collections::HashSet;

    // Tokens originaux (on veut les garder pour conserver les accents/casse)
    let original_tokens: Vec<&str> = question.trim().split_whitespace().collect();
    // Tokens normalisés pour filtrer
    let norm_tokens: Vec<String> = original_tokens.iter().map(|t| normalize(t)).collect();

    // Mots à ignorer (normalisés, sans accents)
    let stop: HashSet<&'static str> = HashSet::from([
        // domaine
        "meteo", "prevision", "previsions", "temps", "weather",
        // connecteurs
        "sur","pour","de","a","au","aux","du","des","la","le","les","dans","en","d","l",
        "moi","donne","dis","quelle","quel","quelles","quels",
        // détails
        "detail", "detaille", "detaillee", "heure", "heures", "toutes",
        "complet", "complete",
        // durée / nombres
        "jour", "jours", "3", "5", "7", "10",
    ]);

    // On cherche le DERNIER token "significatif" en partant de la fin
    for i in (0..norm_tokens.len()).rev() {
        let t = norm_tokens[i].as_str();
        if t.is_empty() { continue; }
        if stop.contains(t) { continue; }
        if t.chars().all(|c| c.is_ascii_digit()) { continue; }

        // Token original, nettoyé de ponctuation finale/début
        let city = original_tokens[i]
            .trim_matches(|c: char| ",.;:?!".contains(c))
            .to_string();

        return city;
    }

    String::new()
}


// --- Détection : requête d’info sur une marque ---

pub fn is_brand_query(question: &str, brand: &str) -> bool {
    let q = normalize(question);
    let b = normalize(brand);

    // Si la marque n’est pas mentionnée, inutile d’aller plus loin
    if !q.contains(&b) {
        return false;
    }

    // Intentions typiques autour de "parle-moi de", "c'est quoi", "qu'est-ce que", etc.
    // (sans accents, car normalisé)
    let intent_phrases = [
        "parle moi de", "parles moi de", "parlez moi de",
        "c est quoi", "c quoi", "qu est ce que", "qu est ce qu est",
        "qui est", "que sais tu de", "infos sur", "informations sur", "information sur",
        "details sur", "presentation de", "presente moi", "decris", "description de",
        "histoire de", "que peux tu me dire sur", "que peut on dire sur",
        "explique moi", "dis m en plus sur"
    ];

    if intent_phrases.iter().any(|p| q.contains(p)) {
        return true;
    }

    // Si la question associe le mot "marque/entreprise/societe" près de la marque, on considère que c’est pertinent.
    // On cherche la proximité dans les deux sens (avant/après), fenêtre de 0 à 16 caractères.
    let pattern = format!(r"(marque|entreprise|societe).{{0,16}}{b}|{b}.{{0,16}}(marque|entreprise|societe)");
    let re = Regex::new(&pattern).unwrap();
    if re.is_match(&q) {
        return true;
    }

    // Questions génériques de type "qu'est-ce que [brand]" (déjà couvert en partie par intent_phrases, mais sécurité)
    let generic = format!(r"(qu est ce que|c est quoi|c quoi|qui est)\s+{b}");
    let re2 = Regex::new(&generic).unwrap();
    re2.is_match(&q)
}

// --- Détection : expression mathématique simple ---

pub fn is_math_expression(question: &str) -> bool {
    // Retire espaces
    let compact: String = question.chars().filter(|c| !c.is_whitespace()).collect();

    // Doit contenir au moins un chiffre et au moins un opérateur
    let has_digit = compact.chars().any(|c| c.is_ascii_digit());
    let has_op = compact.chars().any(|c| matches!(c, '+' | '-' | '*' | '/' ));

    if !has_digit || !has_op {
        return false;
    }

    // Autoriser uniquement chiffres, ., (), et +-*/
    let valid_chars = Regex::new(r"^[0-9+\-*/().]+$").unwrap();
    if !valid_chars.is_match(&compact) {
        return false;
    }

    // Eviter chaîne composée uniquement d’opérateurs (couvert par has_digit), et basiques checks
    // (Optionnel) empêcher opérateurs en fin/début de chaîne (sauf '-' unaire au début)
    let bad_edge = Regex::new(r"^[+*/)]|[+\-*/(]$").unwrap();
    if bad_edge.is_match(&compact) {
        return false;
    }

    true
}

pub async fn get_forecast_detailed(
    city: &str,
    api_key: &str,
    nom_assistant: &str,
    extract_days: fn(&str) -> usize,
    question: &str,
) -> Result<(), Box<dyn std::error::Error>> {
    let units = "metric";
    let url_forecast = format!(
        "http://api.openweathermap.org/data/2.5/forecast?q={}&appid={}&units={}&lang=fr",
        city, api_key, units
    );

    let emoji = if is_windows_10() { "" } else { "\u{2728}" };

    let resp = reqwest::get(&url_forecast).await?;
    if !resp.status().is_success() {
        println!("Erreur lors de la récupération des prévisions : {}", resp.status());
        return Ok(());
    }

    let forecast: ForecastResponse = resp.json().await?;
    let days = extract_days(question);

    println!();
    println!(
        "{}",
        format!(" Prévisions détaillées pour {} :\n ", forecast.city.name)
            .truecolor(50, 145, 100)
    );

    use std::collections::{HashMap, HashSet};

    // 1) Min/Max par date
    let mut minmax: HashMap<String, (f64, f64)> = HashMap::new();
    for entry in &forecast.list {
        let date = &entry.dt_txt[..10];
        let t = entry.main.temp;
        let e = minmax.entry(date.to_string()).or_insert((t, t));
        if t < e.0 { e.0 = t; }
        if t > e.1 { e.1 = t; }
    }

    // 2) Parcours chronologique (déjà trié par l’API) et affichage par jour
    let mut dates_vues = HashSet::new();
    let mut jours_affiches = 0usize;
    let mut current_date = String::new();

    for entry in &forecast.list {
        let date = &entry.dt_txt[..10];
        let heure = &entry.dt_txt[11..16]; // HH:MM

        // Nouveau jour → entête + min/max
        if current_date != date {
            if jours_affiches == days { break; } // on a déjà affiché N jours

            current_date = date.to_string();
            if !dates_vues.contains(&current_date) {
                dates_vues.insert(current_date.clone());
                jours_affiches += 1;

                let (mn, mx) = minmax.get(&current_date).copied().unwrap_or((entry.main.temp, entry.main.temp));
                println!(
                    "{}",
                    format!("\n{} {} {}  —  min {:.1}°C / max {:.1}°C",
                        emoji, nom_assistant, emoji, mn, mx
                    ).truecolor(150,150,150).bold()
                );
                println!(
                    "{}",
                    format!("📅 {}", current_date).truecolor(200,200,200).bold()
                );
            }
        }

        if jours_affiches > days { break; }

        // Données du créneau
        let temp = entry.main.temp;
        let feels = entry.main.feels_like.unwrap_or(entry.main.temp);
        let hum = entry.main.humidity;
        let wind_kmh = entry.wind.speed * 3.6; // m/s -> km/h
        let desc = translate_weather_description(&entry.weather[0].description);

        println!(
            "{}",
            format!(
			"  • {}  |  {:>5.1}°C (ressenti {:>5.1}°C)  |  💧{}%  |  💨{:.1} km/h  |  {}",
				heure, temp, feels, hum, wind_kmh, desc
            ).truecolor(200,200,200)
        );
    }

    println!();
    Ok(())
}

fn translate_weather_description(description: &str) -> String {
    // utilise ta fn normalize(...) déjà présente
    let d = normalize(description);

    // ciel dégagé
    if d.contains("ciel degage") || d.contains("clear sky") {
        return "ciel dégagé ☀️".to_string();
    }

    // nuages (peu / quelques / épars / partiellement / nuageux / overcast)
    if d.contains("peu nuageux") || d.contains("quelques nuages") || d.contains("few clouds") {
        return "peu nuageux 🌤️".to_string();
    }
    if d.contains("nuages disperses") || d.contains("scattered clouds") || d.contains("partiellement nuageux") {
        return "nuages épars 🌥️".to_string();
    }
    if d.contains("nuages fragmentes") || d.contains("broken clouds") || d.contains("nuageux") {
        return "nuageux ☁️".to_string();
    }
    if d.contains("couvert") || d.contains("overcast clouds") {
        return "couvert ☁️".to_string();
    }

    // pluie
    if d.contains("legere pluie") || d.contains("pluie faible") || d.contains("light rain") {
        return "légère pluie 🌦️".to_string();
    }
    if d.contains("pluie moderee") || d.contains("moderate rain") || d.contains("pluie") {
        return "pluie 🌧️".to_string();
    }
    if d.contains("forte pluie") || d.contains("heavy rain") {
        return "forte pluie 🌧️💧".to_string();
    }
    if d.contains("averse") || d.contains("shower") {
        return "averses 🌧️".to_string();
    }

    // orage / neige / brume
    if d.contains("orage") || d.contains("thunderstorm") {
        return "orage ⛈️".to_string();
    }
    if d.contains("neige") || d.contains("snow") {
        return "neige ❄️".to_string();
    }
    if d.contains("brume") || d.contains("brouillard") || d.contains("mist") || d.contains("fog") {
        return "brume 🌫️".to_string();
    }

    // fallback : on renvoie la description d'origine (avec accents) telle quelle
    description.to_string()
}

fn is_update_command(s: &str) -> bool {
    // ajoute librement d'autres synonymes ici
    let keywords = [
        "update",
        "maj",
        "mise a jour",
        "mise à jour",
        "mettre a jour",
        "mettre à jour",
        "upgrade",
        "mise-à-jour",
        "miseajour",
    ];
    keywords.iter().any(|k| s.contains(k))
}

async fn download_file(url: &str, dest: &PathBuf) -> Result<(), Box<dyn std::error::Error>> {
    let resp = reqwest::get(url).await?;
    if !resp.status().is_success() {
        return Err(format!("Téléchargement impossible (HTTP {}).", resp.status()).into());
    }

    // Crée le dossier si besoin
    if let Some(parent) = dest.parent() {
        tokio::fs::create_dir_all(parent).await.ok();
    }

    let bytes = resp.bytes().await?;
    let mut file = tokio::fs::File::create(dest).await?;
    file.write_all(&bytes).await?;
    Ok(())
}

fn default_download_path() -> PathBuf {
    // ~/Téléchargements/AssistantBylseWindows.zip si dispo, sinon ~/AssistantBylseWindows.zip
    let file_name = "AssistantBylseWindows.zip";
    if let Some(ud) = UserDirs::new() {
        if let Some(dl) = ud.download_dir() {
            return dl.join(file_name);
        }
        return ud.home_dir().join(file_name);
    }
    std::env::current_dir().unwrap_or_else(|_| PathBuf::from(".")).join(file_name)
}


async fn resource_available(client: &Client, url: &str) -> Result<bool, reqwest::Error> {
    let head = client.head(url).send().await;
    if let Ok(resp) = head {
        return Ok(resp.status().is_success());
    }

    // Fallback GET (range 0-0) pour minimiser le transfert
    let resp = client
        .get(url)
        .header(reqwest::header::RANGE, "bytes=0-0")
        .send()
        .await?;

    Ok(match resp.status() {
        s if s.is_success() => true,
        StatusCode::PARTIAL_CONTENT => true,
        _ => false,
    })
}

// ===== Check qui renvoie une courte phrase à apposer après le copyright =====
async fn check_update_on_start() -> String {
    let primary = "https://magasin.bylse.app/site/assistantbylse/ressources/AssistantBylseWindows_v1.0.6.zip";
    let fallback = "https://magasin.bylse.app/site/assistantbylse/ressources/version/linux/AssistantBylseWindows_v1.0.6.zip";

    let client = Client::builder()
        .timeout(Duration::from_secs(5))
        .build()
        .unwrap();

    if let Ok(true) = resource_available(&client, primary).await {
        return "Version à jour".to_string(); // discret
    }
    if let Ok(true) = resource_available(&client, fallback).await {
        return "Mise à jour dispo, tapez '?'".to_string();
    }
    String::new() // rien trouvé → rien à ajouter
}

struct App {
    name: &'static str,
    desc: &'static str,
    url:  &'static str,
}

fn bylse_apps() -> Vec<App> {
    vec![
        App { name: "ByKey", desc: "Un gestionnaire de mot de passe", url: "https://serveur.bylse.org/site/bykey/" },
        App { name: "ByGuard",  desc: "Un VPN respectueux de la vie privé",   url: "https://serveur.bylse.org/site/byguard/" },
        App { name: "ByAdventure",  desc: "Un serveur Minecraft aventure",           url: "https://serveur.bylse.org/site/byadventure/" },
        App { name: "Studycook",desc: "Une APP android pour cuisiner",  url: "https://magasin.bylse.app/site/studycook/" },
    ]
}

fn show_launcher() {
    let apps = bylse_apps();

    println!(
        "\n{}",
        "=== Mode Launcher Bylse ===".truecolor(100, 180, 255).bold()
    );
    for (i, a) in apps.iter().enumerate() {
        println!(
            "{} {}  {}",
            format!("{:>2}.", i + 1).truecolor(200,200,200),
            a.name.bold(),
            a.desc.truecolor(160,160,160),
        );
        println!("    {}", a.url.truecolor(120,120,120));
    }
    println!("{}", "\nChoisis un numéro (ou 'q' pour quitter) :".truecolor(255,255,0));

    print!("> ");
    io::stdout().flush().unwrap();

    let mut choice = String::new();
    if io::stdin().read_line(&mut choice).is_err() {
        println!("{}", "Lecture impossible.".truecolor(255, 85, 85));
        return;
    }
    let choice = choice.trim().to_lowercase();
    if choice == "q" || choice == "quit" || choice == "quitter" { return; }

    match choice.parse::<usize>() {
        Ok(n) if (1..=apps.len()).contains(&n) => {
            let app = &apps[n - 1];
            println!(
                "{}",
                format!("\nOuverture de: {} ({})", app.name, app.url)
                    .truecolor(100, 180, 255)
            );
            if webbrowser::open(app.url).is_err() {
                println!("{}", "\nImpossible d’ouvrir le navigateur.".truecolor(255, 85, 85));
            }
        }
        _ => {
            println!("{}", "\nChoix invalide.".truecolor(255, 85, 85));
        }
    }
}
